<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/SocialSharer.php";
    include "gUtil/GestoreTraduzioni.php";
    include "template/stile.php";
    include "classi/GeneratoreUrl.php";
    include "classi/ecommerce/Carrello.php";
    include "classi/ecommerce/PaginaCarrello.php";
    include "classi/GestoreJavascript.php";
    include "template/include/includeClassiTemplate.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);		
    $gestoreJavascript = new GestoreJavascript();
    
    $impostazioni	    = recuperaImpostazioni($geecomDb);
    $impostazioniEcommerce = $geecomDb->leggiSingolaRiga("geecEc_impostazioni",1);
    $impostazioniPagamenti = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPagamenti",1);
    $configurazioneAspetto = recuperaConfigurazioneColori($geecomDb);
    $inclusioni            = recuperaInclusioni($geecomDb);
    $profiliSocial         = $geecomDb->leggiSingolaRiga("geec_profiliSocial",1);
    $datiCookie            = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",1);

    // recupera lo stile scelto, la variabile aspettiSito è contenuta nel file stile.php
    $aspettoSito = $aspettiSito[$impostazioni["aspettoSito"]];
    
    session_start();
    
    $lingua = "italiano"; // verrà sovrascritta nell'if sottostante
    if(isset($_SESSION["carrello"])) { //se il campo passato in input è effettivamente un numero allora fa la query
        $carrello = new Carrello($geecomDb,$_SESSION["carrello"]);
        $carrello->caricaDatiDalDatabase();
        if(isset($_SESSION["geecomUser_id"])) {
            $sessioneUtente = $_SESSION["geecomUser_id"];
            $carrello->setIdUtente($_SESSION["geecomUser_id"]);
        }
        else {
            $sessioneUtente = 0;
        }
	$lingua = $carrello->determinaLinguaCarrello();
	$gestoreTraduzioni  = new GestoreTraduzioni("localizzazione", array($lingua));
	$gestoreTraduzioni->caricaTraduzioni();
	$paginaCarrello = new PaginaCarrello($geecomDb,$_SESSION["carrello"],$gestoreTraduzioni,$lingua);
        
        $ordine = $geecomDb->leggiSingolaRiga("geecEc_ordini",$_SESSION["idOrdine"]);
        $tipoPagamento = $ordine["tipoPagamento"];
    }

    $impostazioniCarrello = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPaginaCarrello",1);

    $gestoreTraduzioni  = new GestoreTraduzioni("localizzazione", [$lingua]);
    $gestoreTraduzioni->caricaTraduzioni();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php 
        echo $inclusioni["inizioHead"]; 
    ?>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Pagina pagamento</title>
    <?php 
	include "include/includeCssBase.php"; 

	echo $inclusioni["fineHead"]; 
    ?>
    <link rel="stylesheet" href="template/css/stripe/normalize.css" />
    <link rel="stylesheet" href="template/css/stripe/global.css" />
</head>

<body class="d-flex flex-column <?= ($impostazioni["attivaBarraSuperiore"]=="si") ? "extraspace" : "" ?>">
    <div class="page-wrapper">
        <!-- menu principale -->
        <?php
            include"template/include/aspetto/{$aspettoSito["cartellaMenu"]}/menuPrincipale.php";
        ?>

        <!-- Inizio contenuto pagina -->
        <main role="main">
            <section class="shopping-cart siOverflow">
                <div class="container">
                     <div class="row">
                        <div id="colonna-principale" class="col-12">
                            <?php 
                                echo $impostazioniCarrello["testoInAlto"];
                                // TODO deve mostrare un riepilogo del carrello senza la possibilità di variare i contenuti
                                $carrello->stampaSommarioCarrello($tipoPagamento);
                                
                                if(isset($_SESSION["carrello"]) && $impostazioniPagamenti["attivaStripe"]=="si") {
                                    include"template/include/ecommerce/datiPagamentoStripe.php";
                                }
                                else if(isset($_SESSION["carrello"]) && $impostazioniPagamenti["attivaPaypal"]=="si") {
                                    include"template/include/ecommerce/datiPagamentoPaypal.php";
                                }
                            ?>
                        </div>
                     </div>
                 </div>
            </section>
        </main>
    </div>
    <?php 
        include "template/include/aspetto/{$aspettoSito["cartellaFooter"]}/footer.php";
	include "template/include/elementiAggiuntiviTemplate.php";

	UtilTemplate::stampaScrollTop();

        include "include/includeJsBase.php";

	// recupero i dati della pagina da visualizzare in caso di acquisto non completato (per i pagamenti online come stripe e paypal)
	// se la pagina non viene impostata non verrà effettuato alcun redirect (e in tal caso paypal mostra gli errori)
	if($impostazioniEcommerce["paginaAcquistoNonEffettuato"]>0) {
		$datiPaginaAcquistoNonCompletato = $geecomDb->leggiSingolaRiga("geecB_contenuti",$impostazioniEcommerce["paginaAcquistoNonEffettuato"]);
		$linkPaginaAcquistoNonCompletato = GeneratoreUrl::creaUrlContenuto($datiPaginaAcquistoNonCompletato,$impostazioni["ottimizzazioneUrl"],$impostazioni["urlSito"]);
	}
	else {
		$linkPaginaAcquistoNonCompletato = "";
	}

        if(isset($_SESSION["carrello"]) && $impostazioniPagamenti["attivaStripe"]=="si") {
    ?>
            <script src="https://js.stripe.com/v3/"></script>
            <script src="js/ecommerce/inizializzazioneStripe.js" defer></script>
    <?php
        }
        else if($impostazioniPagamenti["attivaPaypal"]=="si" && isset($_SESSION["carrello"])) {
		?>
		<script src="https://www.paypal.com/sdk/js?client-id=<?= $impostazioniPagamenti["clientIdPaypal"] ?>&currency=EUR&locale=it_IT&components=messages,buttons,card-fields&enable-funding=paylater"></script>

		<script>
		<?php 
			if($impostazioniPagamenti["attivaPagamento3Rate"]=="si" && $carrello->getImportoTotale()>$impostazioniPagamenti["importoMinimoPagamento3Rate"]) {
				?>
				var FUNDING_SOURCES = [
					paypal.FUNDING.PAYPAL,
					paypal.FUNDING.PAYLATER
				]
				<?php
			}
			else {
				?>
				var FUNDING_SOURCES = [
					paypal.FUNDING.PAYPAL
				]
				<?php
			}
		?>

			// Loop over each payment method
			FUNDING_SOURCES.forEach(function (fundingSource) {

				// Initialize the buttons
				var button = paypal.Buttons({
					createOrder() {
					  return fetch("controller/azioni/ecommerce/creazioneOrdinePaypal.php", {
					    method: "POST",
					    headers: {
					      "Content-Type": "application/json",
					    },
					    body: JSON.stringify({
					      cart: [
					      <?php
							// stampo i carrelli
							$contatoreProdotti   = 1;
							$prodottiNelCarrello = $carrello->getProdottiNelCarrello();
							foreach($prodottiNelCarrello as $prodotto) {
							?>
								{
								  sku: "<?= $prodotto["idProdotto"] ?>",
								  quantity: "<?= $prodotto["quantita"] ?>",
								},
							<?php
							} 
					      ?>
					      ]
					    })
					  })
					  .then((response) => response.json())
					  .then((order) => order.id);
					},
					onApprove: function (data, actions) {
					      let dati = new FormData();
					      dati.append('operazione', 'impostaOrdinePayPalPagato');
					      dati.append('idTransazione', data.orderID);
					      
					      return fetch(`controller/ecommerce/controllerCarrello.php`, {
						method: "post",
						body: dati
					      })
						.then(response => response.text())
						.then((response) =>  {
							if(response=="ok") {
							  location.href="acquistoEffettuato.php";
							}
							else {
							  location.href="<?= $linkPaginaAcquistoNonCompletato ?>";
							}
						});
					},
					onCancel: function(data, actions) {
						location.href="<?= $linkPaginaAcquistoNonCompletato ?>";
					},
					fundingSource: fundingSource,
				})

				// Check if the button is eligible
				if (button.isEligible()) {
					// Render the standalone button for that payment method
					button.render('#paypal-button-container')
				}

			});
			
		<?php
			if($impostazioniPagamenti["attivaPaypalCartaDiCredito"]=="si") { // se è attivo il pagamento con carta di credito
		?>
			/*
			 * codice per usare il 3DS di PayPal 
			 */
			let GlorderID;

			// Create the Card Fields Component and define callbacks
			const cardField = paypal.CardFields({
			  createOrder: function (data) {
			    document.getElementById("spanPulsantePagaPaypal").className = "spinner-border spinner-border-sm mr-2"; // mostra la ruotellina
			    
			    return fetch("controller/azioni/ecommerce/creazioneOrdinePaypal.php?tipo=cartaDiCredito")
			      .then((res) => {
				return res.json();
			      })
			      .then((orderData) => {
				// Updating the global variable in case of catch() error
				GlorderID = orderData.id;
				// Returning order id for onApprove
				return orderData.id;
			      });
			  },

			  // Once we return the order id, the 3D Secure challenge starts
			  // Finalize the transaction after a successfull 3D Secure challenge
			  onApprove: function (data) {
			    const { orderID } = data;
			    // Checking 3DS result to double check we can proceed with Capture
			    return fetch(`controller/azioni/ecommerce/recuperaEsito3dsPaypal.php?id=${orderID}`)
			      .then((res) => {
				return res.json();
			      })
			      .then((orderData) => {
				// orderData.result is what we get returned from the backend after our check above.
				// We are supposed to receive the string "capture", anything else would go to .catch() errors.
				let result;

				if (orderData.result) result = orderData.result;
				
				if (result == "capture") {
				      let dati = new FormData();
				      dati.append('operazione', 'impostaOrdinePayPalPagato');
				      dati.append('idTransazione', orderID);

				      return fetch(`controller/ecommerce/controllerCarrello.php`, {
					method: "post",
					body: dati
				      })
					.then(response => response.text())
					.then((response) =>  {
						if(response=="ok") {
							location.href="acquistoEffettuato.php";
						}
						else {
							document.getElementById("messaggioErrorePaypal").className = "alert alert-danger";
							document.getElementById("messaggioErrorePaypal").innerHTML = response;
						}
					});
				}
			      });
			  },

			  onError: function (error) {
			  	<?php
			  		// se non è stata definita una pagina di errore presente non vengono eseguite azioni e l'sdk mostrerà
			  		// gli errori definiti a video definiti sotto
					if($linkPaginaAcquistoNonCompletato!="") {
				?>
					location.href="<?= $linkPaginaAcquistoNonCompletato ?>";
				<?php
					}
			  	?>
			  }
			});

			// Render each field after checking for eligibility
			if (cardField.isEligible()) {

			  const nameField = cardField.NameField();
			  nameField.render('#card-name-field-container');

			  const numberField = cardField.NumberField();
			  numberField.render('#card-number-field-container');

			  const cvvField = cardField.CVVField();
			  cvvField.render('#card-cvv-field-container');

			  const expiryField = cardField.ExpiryField();
			  expiryField.render('#card-expiry-field-container');

			  // Add click listener to submit button and call the submit function on the CardField component
			  document.getElementById("card-field-submit-button").addEventListener("click", () => {
			    cardField
			      .submit({
				name: "<?= $ordine["destinatario"] ?>",
				billingAddress: {
				  address_line_1: "<?= $ordine["indirizzoSpedizione"] ?>",
				  address_line_2: "",
				  admin_area_2: "<?= $ordine["citta"] ?>",
				  admin_area_1: "",
				  postal_code: "<?= $ordine["capSpedizione"] ?>",
				  country_code: "IT",
				},
			      })
			      // If any error, for example if the 3D Secure does not go through
			      // or if the credit card does not pass the 3DS.
			      // This also includes unexpected errors
			      .catch((err) => {
				document.getElementById("messaggioErrorePaypal").className = "alert alert-danger";
				let divMessagioErrore = document.getElementById("messaggioErrorePaypal");

				// i messaggi di errore possono essere modificati nella sezione traduzioni di Geecom
				let retry        = "<?= $gestoreTraduzioni->traduci("Si è verificato un errore durante la transazione, per favore riprova",$lingua) ?>";
				let unknownError = "<?= $gestoreTraduzioni->traduci("Si è verificato un errore durante la transazione, contatta il fornitore della tua carta di credito",$lingua) ?>";
				let genericIssue = "<?= $gestoreTraduzioni->traduci("Ordine non completato, si è verificato un errore",$lingua) ?>";
				let further      = "<?= $gestoreTraduzioni->traduci("Si è verificato un errore, prova con un altro metodo di pagamento",$lingua) ?>";

				// GlorderID, the global variable with the order id that we have saved in the create order
				if (GlorderID) {
				  return fetch(`controller/azioni/ecommerce/recuperaEsito3dsPaypal.php?id=${GlorderID}`)
				    .then((response) => response.json())
				    .then((tdsresponse) => {

				      let result;
				      if (tdsresponse.result) result = tdsresponse.result;

				      if (result === "unknown") {
					      divMessagioErrore.innerHTML = unknownError;
				      }

				      if (result === "retry") {
					      divMessagioErrore.innerHTML = retry;
				      }
				      if (result === "genericIssue") {
					      divMessagioErrore.innerHTML = genericIssue;
				      }
				      // The unexpected
				      if (result != "unknown" && result != "retry" && result != "genericIssue") {
					      divMessagioErrore.innerHTML = further;
				      }
				      
				      // dopo aver settato l'errore rimuovo la ruotellina
				      document.getElementById("spanPulsantePagaPaypal").className = "d-none"; 
				    });
				} else {
				  // e.g. No order id generated
				  div_mycart.style.display = "none";
				  div_response.style.display = "block";
				  div_json.innerHTML = further;
				  console.log(err);
				}
			      });
			  });
			};
		<?php
			}
		?>
		</script>
		<?php
	    }
        echo $inclusioni["fineBody"];
    ?>
</body>

</html>
